clear all

ssc install reghdfe
ssc install tuples
ssc install estout
ssc install ivreg2 
ssc install coefplot

cd "Z:\Writing up results\Algorithm RDP\R files"

import delimited using "sprdhct_regdata.csv"

// Change NA to missing vavues
foreach v of varlist secpr-hct {
	tostring `v', force replace
	replace `v' = "." if `v' == "NA" | `v' == "-Inf" | `v' == "Inf"
}
destring, replace
// Convert variables from string
encode brwdom, generate(bdom)
encode lnddom, generate(ldom)
encode lndent, generate(lnde)
encode brwent, generate(brwe)
encode sec, generate(sc)
// Rescale variables
replace hct = hct*100
replace sprdsimp = sprdsimp*100
gen lomo = ln(lndomo/1e9 + sqrt((lndomo/1e9)^2 + 1))  // IHS transformation
gen bomo = ln(brwomo/1e9 + sqrt((brwomo/1e9)^2 + 1))
gen lcons = ln(cons/1e6)
// Dummy to use as constant
gen const = day > 0
// Dummy for OMO
gen lomod = lomo > 0
gen bomod = bomo > 0
// Dummies for lender-borrower pair types
gen lbdom = lnddom+brwdom
encode lbdom, generate(lbdom2)
// Dummies for securities
gen ags = sec == "ags"
gen sgs = sec == "sgs"
gen oth = sec == "oth"
// Dummies for maturity buckets
gen m1 = mat == 1
gen m2to7 = mat > 1 & mat < 8
gen m8to14 = mat > 7
gen m14 = mat == 14
tabulate mat, generate(md)

// Dummy for if state gvt involved 
gen stgv = lnddom == "sgv" | brwdom == "sgv"
// Domicile dummies
gen lbaus = lnddom == "aus" & brwdom == "aus"
gen lausbfrn = lnddom == "aus" & brwdom == "frn"
gen lausbcln = lnddom == "aus" & brwdom == "cln"
gen lausbsgv = lnddom == "aus" & brwdom == "sgv"
gen lbfrn = lnddom == "frn" & brwdom == "frn"
gen lfrnbaus = lnddom == "frn" & brwdom == "aus"
gen lfrnbcln = lnddom == "frn" & brwdom == "cln"
gen lfrnbsgv = lnddom == "frn" & brwdom == "sgv"
gen lbcln = lnddom == "cln" & brwdom == "cln"
gen lclnbaus = lnddom == "cln" & brwdom == "aus"
gen lclnbfrn = lnddom == "cln" & brwdom == "frn"
gen lclnbsgv = lnddom == "cln" & brwdom == "sgv"
gen lbsgv = lnddom == "sgv" & brwdom == "sgv"
gen lsgvbaus = lnddom == "sgv" & brwdom == "aus"
gen lsgvbfrn = lnddom == "sgv" & brwdom == "frn"
gen lsgvbcln = lnddom == "sgv" & brwdom == "cln"


/* PLOTTING THE ENTITY-TYPE COEFFICIENT AND CI GRAPH */
// Number of observations for each dummy type
foreach v of varlist lbaus-lclnbfrn {
tab `v' if year > 2014 & !stgv & lndent != brwent
}
// Obtain regression output
reghdfe sprdsimp lcons m2to7 m8to14 sgs oth ///
lausbfrn lausbcln lfrnbaus lbfrn lfrnbcln lclnbaus lclnbfrn lbcln ///
if year > 2014 & !stgv & lndent != brwent, absorb(day) vce(cluster lnde)
// Plot commands
coefplot, drop(lcons m2to7 m8to14 sgs oth) horizontal xline(0) yscale(reverse) recast(scatter) ///
ylabel(1 "Aus to foreign (xxx)" 2 "Aus to client (xxx)" ///
3 "foreign to Aus (xxx)" 4 "foreign to foreign (xxx)" 5 "foreign to client (xxx)" /// 
6 "client to Aus (xxx)" 7 "client to foreign (xxx)" 8 "client to client (x)") ///
ytitle("Counterparty types (no of loans in sample)") ///
xtitle("Difference from Aus to Aus in basis points") ///
title("Estimated repo rates and 95% CIs")


// Spread regressions on repo characteristics with account level FE
quietly reghdfe sprdsimp lcons shrtsale lomo m2to7 m8to14 sgs oth delivsec ///
if year > 2011 & !stgv & lndact != brwact, absorb(day) vce(cluster lndact)
estimates store m1
quietly reghdfe sprdsimp lcons shrtsale lomo m2to7 m8to14 sgs oth delivsec ///
if year > 2011 & !stgv & lndact != brwact, absorb(day lndact#brwact#year) vce(cluster lndact)
estimates store m2
esttab m1 m2 /*using spreadregressions.csv*/,  ///
cells(b(star fmt(3)) se(par fmt(2))) legend varwidth(30) modelwidth(10) ///
r2 star(* 0.1 ** 0.05 *** 0.01) 
// Haircut regressions
quietly reghdfe hct simpint lcons shrtsale lomo m2to7 m8to14 sgs delivsec ///
if year >= 2012 & !stgv & hct > -5 & hct < 5 & lndact != brwact, absorb(day) vce(cluster lndact)
estimates store m1
quietly reghdfe hct simpint lcons shrtsale lomo m2to7 m8to14 sgs delivsec ///
if year >= 2012 & !stgv & hct > -5 & hct < 5 & lndact != brwact, absorb(day lndact#brwact#year) vce(cluster lndact)
estimates store m2
esttab m1 m2 /*using hctregressions.csv*/,  ///
cells(b(star fmt(3)) se(par fmt(2))) legend varwidth(30) modelwidth(10) ///
r2 star(* 0.1 ** 0.05 *** 0.01)
